/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.config;

import com.seibel.distanthorizons.core.config.file.ConfigFileHandling;
import com.seibel.distanthorizons.core.config.types.AbstractConfigType;
import com.seibel.distanthorizons.core.config.types.ConfigCategory;
import com.seibel.distanthorizons.core.config.types.ConfigEntry;
import com.seibel.distanthorizons.core.config.types.ConfigLinkedEntry;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.wrapperInterfaces.config.ILangWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftSharedWrapper;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigBase {
    public static ConfigBase INSTANCE;
    public ConfigFileHandling configFileINSTANCE;
    private final Logger LOGGER;
    public final String modID;
    public final String modName;
    public final int configVersion;
    public boolean isLoaded = false;
    public static final List<Class<?>> acceptableInputs;
    public boolean disableMinMax = false;
    public final List<AbstractConfigType<?, ?>> entries = new ArrayList();

    public ConfigBase(String modID, String modName, Class<?> config) {
        this(modID, modName, config, ConfigBase.getConfigPath(modName), -1);
    }

    public ConfigBase(String modID, String modName, Class<?> config, Path configPath) {
        this(modID, modName, config, configPath, -1);
    }

    public ConfigBase(String modID, String modName, Class<?> config, int configVersion) {
        this(modID, modName, config, ConfigBase.getConfigPath(modName), configVersion);
    }

    public ConfigBase(String modID, String modName, Class<?> config, Path configPath, int configVersion) {
        this.LOGGER = LogManager.getLogger((String)(this.getClass().getSimpleName() + ", " + modID));
        this.LOGGER.info("Initialising config for " + modName);
        this.modID = modID;
        this.modName = modName;
        this.configVersion = configVersion;
        this.initNestedClass(config, "");
        this.configFileINSTANCE = new ConfigFileHandling(this, configPath);
        this.configFileINSTANCE.loadFromFile();
        this.isLoaded = true;
        this.LOGGER.info("Config for " + modName + " initialised");
    }

    private void initNestedClass(Class<?> config, String category) {
        for (Field field : config.getFields()) {
            if (!AbstractConfigType.class.isAssignableFrom(field.getType())) continue;
            try {
                this.entries.add((AbstractConfigType)field.get(field.getType()));
            }
            catch (IllegalAccessException exception) {
                this.LOGGER.warn((Object)exception);
            }
            AbstractConfigType<?, ?> entry = this.entries.get(this.entries.size() - 1);
            entry.category = category;
            entry.name = field.getName();
            entry.configBase = this;
            if (ConfigEntry.class.isAssignableFrom(field.getType()) && !ConfigBase.isAcceptableType(entry.getType())) {
                this.LOGGER.error("Invalid variable type at [" + (category.isEmpty() ? "" : category + ".") + field.getName() + "].");
                this.LOGGER.error("Type [" + entry.getType() + "] is not one of these types [" + acceptableInputs.toString() + "]");
                this.entries.remove(this.entries.size() - 1);
            }
            if (!ConfigCategory.class.isAssignableFrom(field.getType())) continue;
            assert (entry instanceof ConfigCategory);
            if (((ConfigCategory)entry).getDestination() == null) {
                ((ConfigCategory)entry).destination = entry.getNameWCategory();
            }
            if (entry.get() == null) continue;
            this.initNestedClass((Class)((ConfigCategory)entry).get(), ((ConfigCategory)entry).getDestination());
        }
    }

    private static boolean isAcceptableType(Class<?> Clazz) {
        if (Clazz.isEnum()) {
            return true;
        }
        return acceptableInputs.contains(Clazz);
    }

    public static Path getConfigPath(String modName) {
        return SingletonInjector.INSTANCE.get(IMinecraftSharedWrapper.class).getInstallationDirectory().toPath().resolve("config").resolve(modName + ".toml");
    }

    public String generateLang(boolean onlyShowNew, boolean checkEnums) {
        ILangWrapper langWrapper = SingletonInjector.INSTANCE.get(ILangWrapper.class);
        ArrayList enumList = new ArrayList();
        String generatedLang = "";
        String starter = "  \"";
        String separator = "\":\n    \"";
        String ending = "\",\n";
        for (AbstractConfigType<?, ?> abstractConfigType : this.entries) {
            String entryPrefix = "lod.config." + abstractConfigType.getNameWCategory();
            if (checkEnums && abstractConfigType.getType().isEnum() && !enumList.contains(abstractConfigType.getType())) {
                enumList.add(abstractConfigType.getType());
            }
            if (onlyShowNew && !langWrapper.langExists(entryPrefix)) continue;
            if (!ConfigLinkedEntry.class.isAssignableFrom(abstractConfigType.getClass())) {
                generatedLang = generatedLang + starter + entryPrefix + separator + langWrapper.getLang(entryPrefix) + ending;
            }
            if (!langWrapper.langExists(entryPrefix + ".@tooltip")) continue;
            generatedLang = generatedLang + starter + entryPrefix + ".@tooltip" + separator + langWrapper.getLang(entryPrefix + ".@tooltip").replaceAll("\n", "\\\\n").replaceAll("\"", "\\\\\"") + ending;
        }
        if (!enumList.isEmpty()) {
            generatedLang = generatedLang + "\n";
            for (Class clazz : enumList) {
                for (Object enumStr : new ArrayList(EnumSet.allOf(clazz))) {
                    String enumPrefix = "lod.config.enum." + clazz.getSimpleName() + "." + enumStr.toString();
                    if (onlyShowNew && !langWrapper.langExists(enumPrefix)) continue;
                    generatedLang = generatedLang + starter + enumPrefix + separator + langWrapper.getLang(enumPrefix) + ending;
                }
            }
        }
        return generatedLang;
    }

    static {
        acceptableInputs = new ArrayList<Class<?>>(){
            {
                this.add(Boolean.class);
                this.add(Byte.class);
                this.add(Integer.class);
                this.add(Double.class);
                this.add(Short.class);
                this.add(Long.class);
                this.add(Float.class);
                this.add(String.class);
                this.add(List.class);
                this.add(ArrayList.class);
                this.add(Map.class);
                this.add(HashMap.class);
            }
        };
    }
}

